 /*******************************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Queue
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 *******************************************************************/

 #ifndef __BSQUEUE1_H
 #define __BSQUEUE1_H

 #include "atomic.h"     // class Atomic
 #include "string.h"	 // class String
 #include "list.h"

 class BSQueue1 : public Atomic
 {
   public:
	       BSQueue1( const std::string &name = "BSQueue1" );	//Default constructor
	       virtual std::string className() const { return "BSQueue1"; }
	       ~BSQueue1();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &IB0,&IB2,&IB3,&IB4,&IB5,&IB6,&Req;
	        Port &Out;
	        Time ProcessTime;
	        typedef list<Value> ElementList ;
	        ElementList elements;
	        int Request;
	        int Qlen;
         	enum State{
			            Idle,       //initial state
			            Push,
			            Pop,
		              };
		    State state;
 };	// class BSQueue1

 #endif   //__BSQUEUE1_H
